-- This actor is duplicated.  Upvalues will not be duplicated.

local grades = {
	Grade_Tier01 = THEME:GetString("Grade","Tier01");
	Grade_Tier02 = THEME:GetString("Grade","Tier02");
	Grade_Tier03 = THEME:GetString("Grade","Tier03");
	Grade_Tier04 = THEME:GetString("Grade","Tier04");
	Grade_Tier05 = THEME:GetString("Grade","Tier05");
	Grade_Tier06 = THEME:GetString("Grade","Tier06");
	Grade_Tier07 = THEME:GetString("Grade","Tier07");
	Grade_Failed = THEME:GetString("Grade","Failed");
	Grade_None = "";
};

local prefixes = {
	PlayerNumber_P1 = "P1: ";
	PlayerNumber_P2 = "P2: ";
};

local function Difficulty(pn)
	if not pn then return end
	
	local steps = GAMESTATE:GetCurrentSteps(pn) or GAMESTATE:GetCurrentTrail(pn);
	local difficulty = steps:GetDifficulty();
	return DifficultyColor(difficulty);
end;

local t = LoadFont("","std07_63")..{
	-- normally I'd SetTextureFiltering,false; on a pixel font but with the
	-- new music wheel transform it looks like ass without filtering
	InitCommand=cmd(shadowlength,0;horizalign,left);
	SetGradeCommand=function(self, params)
		local grade = grades[params.Grade] or grades.Grade_None;
		local prefix = prefixes[params.PlayerNumber] or "";
		
		-- old code that diffused based on player; use this for any
		-- general purpose, it's fine by me! -syn
		--[[
		local attr = {
			Length = string.len(grade);
			Diffuse = Difficulty(params.PlayerNumber);
		};
		--self:AddAttribute(4,attr);
		]]
		
		-- invisibo hack
		if grade == grades.Grade_None then prefix = ""; end;
		
		self:settext(prefix .. grade);
		self:diffusecolor(Difficulty(params.PlayerNumber));
	end;
};

return t;

-- original (c) 2007 Glenn Maynard
-- new  2008 Synikal